<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/download/{platform}/{version}/{filename}', function($platform, $version, $filename) {

    $file_path = storage_path('karfarma/applications/'. '/' . $platform . '/' . $version . '/' . $filename);

    if (file_exists($file_path)) {

        return response()->download($file_path, $filename, [
            'Content-Length: '. filesize($file_path)
        ]);

    } else {

        abort('404');
    }
});
